/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWLoggingOptionType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLUtil;
import java.util.Date;

public final class VWMilestoneElement
extends VWMLABase
implements IVWtoXML {
    private int milestoneId = -1;
    private String name = null;
    private int level = -1;
    private int stepId = -1;
    private int instructionSheetId = -1;
    private String instructionSheetName = null;
    private Date timestamp = null;
    private String message = null;
    private VWLogElement logElement = null;

    protected VWMilestoneElement(VWMilestoneDefinition[] theMSDefs, VWLogElement logEle) throws VWException {
        if (logEle.getEventType() != 125) {
            throw new VWException("vw.api.VWMilestoneElementNotMilestoneEvent", "The log element is event type {0}, ({1}), which is not a milestone", String.valueOf(logEle.getEventType()), VWLoggingOptionType.getLocalizedString(logEle.getEventType()));
        }
        if (theMSDefs == null) {
            throw new VWException("vw.api.VWMilestoneElementMSDefsIsNull", "The milestone definitions parameter cannot be null");
        }
        this.milestoneId = (Integer)logEle.getFieldValue("F_OperationId");
        this.name = theMSDefs[this.milestoneId].getName();
        this.level = logEle.getMachineId();
        this.stepId = logEle.getWorkOrderId();
        this.instructionSheetId = (Integer)logEle.getFieldValue("F_InstrSheetId");
        this.instructionSheetName = logEle.getInstructionSheetName();
        this.timestamp = logEle.getTimeStamp();
        this.message = logEle.getText();
        this.logElement = logEle;
    }

    protected VWMilestoneElement(VWMilestoneDefinition milestoneDefinition, int id) throws VWException {
        this.milestoneId = id;
        this.name = milestoneDefinition.getName();
        this.level = milestoneDefinition.getLevel();
        this.message = milestoneDefinition.getMessage();
    }

    public int getMilestoneId() {
        return this.milestoneId;
    }

    public int getLevel() {
        return this.level;
    }

    public int getStepId() {
        return this.stepId;
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public int getInstructionSheetId() {
        return this.instructionSheetId;
    }

    public String getInstructionSheetName() {
        return this.translateStr(this.instructionSheetName);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public VWLogElement getLogElement() {
        return this.logElement;
    }

    public String toString() {
        String timest = null;
        if (this.timestamp != null) {
            timest = this.timestamp.toString();
        }
        return "id:" + this.milestoneId + ",name:" + this.name + ",level:" + this.level + ",step:" + this.stepId + ",map:" + this.instructionSheetName + "," + timest + "," + this.message;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWStepElementNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("<Milestone");
        if (this.milestoneId >= 0) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Id=\"" + Integer.toString(this.milestoneId) + "\"");
        }
        theBuffer.append("\n" + ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"");
        theBuffer.append("\n" + ATTRIB_INDENT + "Level=\"" + Integer.toString(this.level) + "\"");
        if (this.instructionSheetName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Map=\"" + VWXMLHandler.toXMLString(this.getInstructionSheetName()) + "\"");
        }
        if (this.stepId >= 0) {
            theBuffer.append("\n" + ATTRIB_INDENT + "StepId=\"" + Integer.toString(this.stepId) + "\"");
        }
        if (this.message != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Message=\"" + VWXMLHandler.toXMLString(this.message) + "\"");
        }
        if (this.timestamp != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Reached=\"" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString(this.timestamp)) + "\"");
        }
        theBuffer.append("/>\n");
    }
}

